
    <div class="virtual-reality border-radius-xl mt-3 mx-3 position-relative"
        style="background-image: url('../../../assets/img/vr-bg.jpg') ; background-size: cover;">
        @include('layouts.navbars.auth.sidebar')
        <main class="main-content mt-1 border-radius-lg">
            <div class="section min-vh-85 position-relative transform-scale-0 transform-scale-md-6">
                <div class="container ms-n0 ms-md-n5">
                    <div class="row">
                        <div class="col-lg-7 mb-lg-0 mb-4 position-relative z-index-2">
                            <div class="card card-plain mb-4">
                                <div class="card-body p-3">
                                    <div class="row">
                                        <div class="col-lg-6">
                                            <div class="d-flex flex-column h-100">
                                                <h2 class="font-weight-bolder mb-0mt-4 fadeIn1 fadeInBottom">General
                                                    Statistics</h2>
                                                <div class="d-flex align-items-center">
                                                    <h6 class="font-weight-bolder mb-0 fadeIn4 fadeInBottom">All users
                                                    </h6>
                                                    <a class="text-primary text-sm font-weight-bold mb-0 icon-move-right ms-4 mt-1 fadeIn4 fadeInBottom"
                                                        href="javascript:;">
                                                        Read More
                                                        <i class="fas fa-arrow-right text-sm ms-1"
                                                            aria-hidden="true"></i>
                                                    </a>
                                                </div>
                                                <h1 class="font-weight-bolder mb-0 fadeIn4 fadeInBottom">1,600,000</h1>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-6 col-12">
                                    <div class="card fadeIn1 fadeInBottom mb-4">
                                        <div class="card-body p-3">
                                            <div class="row">
                                                <div class="col-8">
                                                    <div class="numbers">
                                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">Today's
                                                            Money</p>
                                                        <h5 class="font-weight-bolder mb-0">
                                                            $53,000
                                                            <span
                                                                class="text-success text-sm font-weight-bolder">+55%</span>
                                                        </h5>
                                                    </div>
                                                </div>
                                                <div class="col-4 text-end">
                                                    <div
                                                        class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                                        <i class="ni ni-money-coins text-lg opacity-10"
                                                            aria-hidden="true"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card fadeIn2 fadeInBottom">
                                        <div class="card-body p-3">
                                            <div class="row">
                                                <div class="col-8">
                                                    <div class="numbers">
                                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">Today's
                                                            Users</p>
                                                        <h5 class="font-weight-bolder mb-0">
                                                            2,300
                                                            <span
                                                                class="text-success text-sm font-weight-bolder">+3%</span>
                                                        </h5>
                                                    </div>
                                                </div>
                                                <div class="col-4 text-end">
                                                    <div
                                                        class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                                        <i class="ni ni-world text-lg opacity-10"
                                                            aria-hidden="true"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-6 col-12 mt-4 mt-md-0">
                                    <div class="card fadeIn3 fadeInBottom mb-4">
                                        <div class="card-body p-3">
                                            <div class="row">
                                                <div class="col-8">
                                                    <div class="numbers">
                                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">New
                                                            Clients</p>
                                                        <h5 class="font-weight-bolder mb-0">
                                                            +3,462
                                                            <span
                                                                class="text-danger text-sm font-weight-bolder">-2%</span>
                                                        </h5>
                                                    </div>
                                                </div>
                                                <div class="col-4 text-end">
                                                    <div
                                                        class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                                        <i class="ni ni-paper-diploma text-lg opacity-10"
                                                            aria-hidden="true"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card fadeIn4 fadeInBottom">
                                        <div class="card-body p-3">
                                            <div class="row">
                                                <div class="col-8">
                                                    <div class="numbers">
                                                        <p class="text-sm mb-0 text-capitalize font-weight-bold">Sales
                                                        </p>
                                                        <h5 class="font-weight-bolder mb-0">
                                                            $103,430
                                                            <span
                                                                class="text-success text-sm font-weight-bolder">+5%</span>
                                                        </h5>
                                                    </div>
                                                </div>
                                                <div class="col-4 text-end">
                                                    <div
                                                        class="icon icon-shape bg-gradient-primary shadow text-center border-radius-md">
                                                        <i class="ni ni-cart text-lg opacity-10" aria-hidden="true"></i>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <div class="card fadeIn3 fadeInBottom">
                                        <div class="card-header pb-0 p-3">
                                            <div class="d-flex justify-content-between">
                                                <h6 class="mb-2">Sales by Country</h6>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table class="table align-items-center ">
                                                <tbody>
                                                    <tr>
                                                        <td class="w-30">
                                                            <div class="d-flex px-2 py-1 align-items-center">
                                                                <div>
                                                                    <img src="../../../assets/img/icons/flags/US.png"
                                                                        alt="Country flag">
                                                                </div>
                                                                <div class="ms-4">
                                                                    <p class="text-xs font-weight-bold mb-0">Country:
                                                                    </p>
                                                                    <h6 class="text-sm mb-0">United States</h6>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Sales:</p>
                                                                <h6 class="text-sm mb-0">2500</h6>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Value:</p>
                                                                <h6 class="text-sm mb-0">$230,900</h6>
                                                            </div>
                                                        </td>
                                                        <td class="align-middle text-sm">
                                                            <div class="col text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Bounce:</p>
                                                                <h6 class="text-sm mb-0">29.9%</h6>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="w-30">
                                                            <div class="d-flex px-2 py-1 align-items-center">
                                                                <div>
                                                                    <img src="../../../assets/img/icons/flags/DE.png"
                                                                        alt="Country flag">
                                                                </div>
                                                                <div class="ms-4">
                                                                    <p class="text-xs font-weight-bold mb-0">Country:
                                                                    </p>
                                                                    <h6 class="text-sm mb-0">Germany</h6>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Sales:</p>
                                                                <h6 class="text-sm mb-0">3.900</h6>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Value:</p>
                                                                <h6 class="text-sm mb-0">$440,000</h6>
                                                            </div>
                                                        </td>
                                                        <td class="align-middle text-sm">
                                                            <div class="col text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Bounce:</p>
                                                                <h6 class="text-sm mb-0">40.22%</h6>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="w-30">
                                                            <div class="d-flex px-2 py-1 align-items-center">
                                                                <div>
                                                                    <img src="../../../assets/img/icons/flags/GB.png"
                                                                        alt="Country flag">
                                                                </div>
                                                                <div class="ms-4">
                                                                    <p class="text-xs font-weight-bold mb-0">Country:
                                                                    </p>
                                                                    <h6 class="text-sm mb-0">Great Britain</h6>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Sales:</p>
                                                                <h6 class="text-sm mb-0">1.400</h6>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Value:</p>
                                                                <h6 class="text-sm mb-0">$190,700</h6>
                                                            </div>
                                                        </td>
                                                        <td class="align-middle text-sm">
                                                            <div class="col text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Bounce:</p>
                                                                <h6 class="text-sm mb-0">23.44%</h6>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="w-30">
                                                            <div class="d-flex px-2 py-1 align-items-center">
                                                                <div>
                                                                    <img src="../../../assets/img/icons/flags/BR.png"
                                                                        alt="Country flag">
                                                                </div>
                                                                <div class="ms-4">
                                                                    <p class="text-xs font-weight-bold mb-0">Country:
                                                                    </p>
                                                                    <h6 class="text-sm mb-0">Brasil</h6>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Sales:</p>
                                                                <h6 class="text-sm mb-0">562</h6>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Value:</p>
                                                                <h6 class="text-sm mb-0">$143,960</h6>
                                                            </div>
                                                        </td>
                                                        <td class="align-middle text-sm">
                                                            <div class="col text-center">
                                                                <p class="text-xs font-weight-bold mb-0">Bounce:</p>
                                                                <h6 class="text-sm mb-0">32.14%</h6>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-12">
                            <div id="globe"
                                class="position-absolute end-0 top-10 mt-3 me-n8 me-lg-10 fadeIn4 fadeInBottom d-none d-md-block">
                                <canvas width="1000" height="1000"></canvas>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
    
    <script src="../../../assets/js/plugins/threejs.js"></script>
    <script src="../../../assets/js/plugins/orbit-controls.js"></script>
    <script src="../../../assets/js/plugins/chartjs.min.js"></script>
    <script>
      (function() {
        const container = document.getElementById("globe");
        const canvas = container.getElementsByTagName("canvas")[0];
  
        const globeRadius = 100;
        const globeWidth = 4098 / 2;
        const globeHeight = 1968 / 2;
  
        function convertFlatCoordsToSphereCoords(x, y) {
          let latitude = ((x - globeWidth) / globeWidth) * -180;
          let longitude = ((y - globeHeight) / globeHeight) * -90;
          latitude = (latitude * Math.PI) / 180;
          longitude = (longitude * Math.PI) / 180;
          const radius = Math.cos(longitude) * globeRadius;
  
          return {
            x: Math.cos(latitude) * radius,
            y: Math.sin(longitude) * globeRadius,
            z: Math.sin(latitude) * radius
          };
        }
  
        function makeMagic(points) {
          const {
            width,
            height
          } = container.getBoundingClientRect();
  
          // 1. Setup scene
          const scene = new THREE.Scene();
          // 2. Setup camera
          const camera = new THREE.PerspectiveCamera(45, width / height);
          // 3. Setup renderer
          const renderer = new THREE.WebGLRenderer({
            canvas,
            antialias: true
          });
          renderer.setSize(width, height);
          // 4. Add points to canvas
          // - Single geometry to contain all points.
          const mergedGeometry = new THREE.Geometry();
          // - Material that the dots will be made of.
          const pointGeometry = new THREE.SphereGeometry(0.5, 1, 1);
          const pointMaterial = new THREE.MeshBasicMaterial({
            color: "#989db5",
          });
  
          for (let point of points) {
            const {
              x,
              y,
              z
            } = convertFlatCoordsToSphereCoords(
              point.x,
              point.y,
              width,
              height
            );
  
            if (x && y && z) {
              pointGeometry.translate(x, y, z);
              mergedGeometry.merge(pointGeometry);
              pointGeometry.translate(-x, -y, -z);
            }
          }
  
          const globeShape = new THREE.Mesh(mergedGeometry, pointMaterial);
          scene.add(globeShape);
  
          container.classList.add("peekaboo");
  
          // Setup orbital controls
          camera.orbitControls = new THREE.OrbitControls(camera, canvas);
          camera.orbitControls.enableKeys = false;
          camera.orbitControls.enablePan = false;
          camera.orbitControls.enableZoom = false;
          camera.orbitControls.enableDamping = false;
          camera.orbitControls.enableRotate = true;
          camera.orbitControls.autoRotate = true;
          camera.position.z = -265;
  
          function animate() {
            // orbitControls.autoRotate is enabled so orbitControls.update
            // must be called inside animation loop.
            camera.orbitControls.update();
            requestAnimationFrame(animate);
            renderer.render(scene, camera);
          }
          animate();
        }
  
        function hasWebGL() {
          const gl =
            canvas.getContext("webgl") || canvas.getContext("experimental-webgl");
          if (gl && gl instanceof WebGLRenderingContext) {
            return true;
          } else {
            return false;
          }
        }
  
        function init() {
          if (hasWebGL()) {
            window
            window.fetch("https://raw.githubusercontent.com/creativetimofficial/public-assets/master/soft-ui-dashboard-pro/assets/js/points.json")
              .then(response => response.json())
              .then(data => {
                makeMagic(data.points);
              });
          }
        }
        init();
      })();
    </script>